<?php

defined('ABSPATH') || exit;

global $ulz_submission;

$listing_types = get_posts([
    'post_type' => 'ulz_listing_type',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'meta_query' => [
        [
            'key' => 'ulz_disable_user_submission',
            'value' => '',
            'compare' => '='
        ],
    ]
]);

?>

<div class="ulz-submission-heading">
    <h3 class="ulz--title">
        <?php esc_html_e( 'Select Submission Type', 'utillz-core' ); ?>
    </h3>
</div>

<form method="get" name="ulz-submit-type" action="<?php echo Ucore()->is_submission(); ?>">

    <div class="ulz-submission-types ulz-no-select">
        <?php foreach( $listing_types as $type ): ?>
            <label class="ulz--type">
                <span class="ulz--radio">
                    <input type="radio" name="type" value="<?php echo esc_html( Ucore()->get( 'ulz_slug', $type->ID ) ); ?>">
                    <span></span>
                </span>
                <span class="ulz--image">
                    <?php if( has_post_thumbnail( $type->ID ) ): ?>
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $type->ID ) ); ?>
                        <span class="ulz--img" style="background-image: url(<?php echo esc_url( $image[0] ); ?>);"></span>
                    <?php else: ?>
                        <?php echo Ucore()->dummy( Ucore()->get('ulz_icon__icon', $type->ID), Ucore()->get('ulz_icon__set', $type->ID), 100 ); ?>
                    <?php endif; ?>
                </span>
                <span class="ulz--content">
                    <span class="ulz--title"><?php echo Ucore()->get( 'ulz_name', $type->ID ); ?></span>
                </span>
                <span class="ulz--action">
                    <span class="ulz-button">
                        <span><?php esc_html_e( 'Select', 'utillz-core' ); ?></span>
                        <?php Ucore()->preloader(); ?>
                    </span>
                </span>
            </label>
        <?php endforeach; ?>
    </div>

    <div class="ulz-submission-error">
        <div class="ulz--error">
            <div class="ulz--content">
                <i class="fas fa-frown-open ulz-mr-1"></i>
                <?php esc_html_e( 'Please select a listing type', 'utillz-core' ); ?>
            </div>
        </div>
    </div>

    <!-- <div class="ulz-submission-footer">
        <a href="#" class="ulz-button ulz-button-accent ulz--large" <?php echo is_user_logged_in() ? 'data-action="submission-submit-type"' : 'data-modal="signin"'; ?>>
            <span><?php esc_html_e( 'Continue', 'utillz-core' ); ?></span>
            <span class="fas fa-arrow-right ulz-ml-1"></span>
        </a>
    </div> -->

</form>
